/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.jira.ui.internal;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.StringUtil;
import com.aptana.jira.core.JiraIssueSeverity;
import com.aptana.jira.core.JiraIssueType;
import com.aptana.jira.ui.JiraUIPlugin;
import com.aptana.jira.ui.internal.Messages;
import com.aptana.jira.ui.preferences.JiraPreferencePageProvider;
import com.aptana.ui.preferences.IAccountPageProvider;
import com.aptana.ui.util.SWTUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitTicketDialog
extends TitleAreaDialog {
    private static final String IMAGE_PATH = "icons/full/wizban/jira_wiz.png";
    private JiraPreferencePageProvider userInfoProvider;
    private Control userInfoControl;
    private ComboViewer typeCombo;
    private ComboViewer severityCombo;
    private Text summaryText;
    private Text reproduceText;
    private Text actualResultText;
    private Text expectedResultText;
    private Button studioLogCheckbox;
    private Button diagnosticLogCheckbox;
    private Text screenshotText;
    private Button browseButton;
    private Composite screenshotsComposite;
    private List<Button> screenshotCheckboxes;
    private ProgressMonitorPart progressMonitorPart;
    private JiraIssueType type;
    private JiraIssueSeverity severity;
    private String summary;
    private String description;
    private boolean studioLogSelected;
    private boolean diagnosticLogSelected;
    private Set<IPath> screenshots;

    public SubmitTicketDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.screenshotCheckboxes = new ArrayList<Button>();
        this.screenshots = new LinkedHashSet<IPath>();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(this.getShellStyle() | 0x10);
    }

    public JiraIssueType getType() {
        return this.type;
    }

    public JiraIssueSeverity getSeverity() {
        return this.severity;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getStudioLogSelected() {
        return this.studioLogSelected;
    }

    public boolean getDiagnosticLogSelected() {
        return this.diagnosticLogSelected;
    }

    public Set<IPath> getScreenshots() {
        return new LinkedHashSet<IPath>(this.screenshots);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SubmitTicketDialog_ShellTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        main.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label separator = new Label(main, 258);
        separator.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.userInfoProvider = new JiraPreferencePageProvider();
        this.userInfoControl = this.userInfoProvider.createContents(main);
        this.userInfoControl.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        Label label = new Label(main, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.SubmitTicketDialog_LBL_Type));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.typeCombo = new ComboViewer(main, 12);
        this.typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.typeCombo.setInput((Object)JiraIssueType.values());
        this.typeCombo.getControl().setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.typeCombo.setSelection((ISelection)new StructuredSelection((Object)JiraIssueType.BUG));
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SubmitTicketDialog.this.validate();
            }
        };
        this.typeCombo.addSelectionChangedListener(listener);
        label = new Label(main, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.SubmitTicketDialog_LBL_Severity));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.severityCombo = new ComboViewer(main, 12);
        this.severityCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.severityCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.severityCombo.setInput((Object)JiraIssueSeverity.values());
        this.severityCombo.getControl().setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.severityCombo.setSelection((ISelection)new StructuredSelection((Object)JiraIssueSeverity.MINOR));
        this.severityCombo.addSelectionChangedListener(listener);
        label = new Label(main, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.SubmitTicketDialog_LBL_Summary));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.summaryText = new Text(main, 2052);
        this.summaryText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SubmitTicketDialog.this.validate();
            }
        };
        this.summaryText.addModifyListener(modifyListener);
        label = new Label(main, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.SubmitTicketDialog_LBL_StepsToReproduce));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 1).create());
        this.reproduceText = new Text(main, 2626);
        this.reproduceText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(-1, 100).create());
        this.reproduceText.addModifyListener(modifyListener);
        TraverseListener traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        };
        this.reproduceText.addTraverseListener(traverseListener);
        label = new Label(main, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.SubmitTicketDialog_LBL_ActualResult));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 1).create());
        this.actualResultText = new Text(main, 2626);
        this.actualResultText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(-1, 50).create());
        this.actualResultText.addModifyListener(modifyListener);
        this.actualResultText.addTraverseListener(traverseListener);
        label = new Label(main, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.SubmitTicketDialog_LBL_ExpectedResult));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 1).create());
        this.expectedResultText = new Text(main, 2626);
        this.expectedResultText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(-1, 50).create());
        this.expectedResultText.addModifyListener(modifyListener);
        this.expectedResultText.addTraverseListener(traverseListener);
        label = new Label(main, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.SubmitTicketDialog_LBL_LogsToAttach));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        Composite composite = new Composite(main, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.studioLogCheckbox = new Button(composite, 32);
        this.studioLogCheckbox.setText(Messages.SubmitTicketDialog_LBL_StudioLog);
        this.studioLogCheckbox.setSelection(true);
        this.diagnosticLogCheckbox = new Button(composite, 32);
        this.diagnosticLogCheckbox.setText(Messages.SubmitTicketDialog_LBL_DiagnosticLog);
        this.diagnosticLogCheckbox.setSelection(true);
        label = new Label(main, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.SubmitTicketDialog_LBL_Screenshots));
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        composite = new Composite(main, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.screenshotText = new Text(composite, 2060);
        this.screenshotText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.screenshotText.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                SubmitTicketDialog.this.browse();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        this.browseButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubmitTicketDialog.this.browse();
            }
        });
        label = new Label(main, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.screenshotsComposite = new Composite(main, 0);
        this.screenshotsComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.screenshotsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.progressMonitorPart = new ProgressMonitorPart(main, (Layout)GridLayoutFactory.fillDefaults().create());
        this.progressMonitorPart.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).exclude(true).span(2, 1).create());
        this.userInfoProvider.setProgressMonitor((IProgressMonitor)this.progressMonitorPart);
        this.userInfoProvider.addValidationListener(new IAccountPageProvider.IValidationListener(){

            public void preValidationStart() {
                SubmitTicketDialog.this.setUILocked(true);
                SubmitTicketDialog.this.progressMonitorPart.setVisible(true);
                ((GridData)((SubmitTicketDialog)SubmitTicketDialog.this).progressMonitorPart.getLayoutData()).exclude = false;
                SubmitTicketDialog.this.layoutShell();
            }

            public void postValidationEnd() {
                SubmitTicketDialog.this.setUILocked(false);
                if (!SubmitTicketDialog.this.progressMonitorPart.isDisposed()) {
                    SubmitTicketDialog.this.progressMonitorPart.setVisible(false);
                    ((GridData)((SubmitTicketDialog)SubmitTicketDialog.this).progressMonitorPart.getLayoutData()).exclude = true;
                    SubmitTicketDialog.this.layoutShell();
                }
            }
        });
        this.setTitle(Messages.SubmitTicketDialog_Title);
        this.setTitleImage(SWTUtils.getImage((AbstractUIPlugin)JiraUIPlugin.getDefault(), (String)IMAGE_PATH));
        this.setMessage(Messages.SubmitTicketDialog_DefaultMessage);
        return main;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    protected void cancelPressed() {
        this.progressMonitorPart.setCanceled(true);
        super.cancelPressed();
    }

    protected void okPressed() {
        if (!this.userInfoProvider.performOk()) {
            return;
        }
        this.type = (JiraIssueType)((IStructuredSelection)this.typeCombo.getSelection()).getFirstElement();
        this.severity = (JiraIssueSeverity)((IStructuredSelection)this.severityCombo.getSelection()).getFirstElement();
        this.summary = this.summaryText.getText();
        this.description = MessageFormat.format("h3. Steps to Reproduce\n{0}\n\nh3. Actual Result\n{1}\n\nh3. Expected Result\n{2}", this.reproduceText.getText(), this.actualResultText.getText(), this.expectedResultText.getText());
        this.studioLogSelected = this.studioLogCheckbox.getSelection();
        this.diagnosticLogSelected = this.diagnosticLogCheckbox.getSelection();
        super.okPressed();
    }

    protected boolean validate() {
        Button button;
        String message = null;
        if (this.typeCombo.getSelection().isEmpty()) {
            message = Messages.SubmitTicketDialog_ERR_EmptyType;
        } else if (StringUtil.isEmpty((String)this.summaryText.getText())) {
            message = Messages.SubmitTicketDialog_ERR_EmptySummary;
        } else if (StringUtil.isEmpty((String)this.reproduceText.getText())) {
            message = Messages.SubmitTicketDialog_ERR_EmptyStepsToReproduce;
        } else if (StringUtil.isEmpty((String)this.actualResultText.getText())) {
            message = Messages.SubmitTicketDialog_ERR_EmptyActualResult;
        } else if (StringUtil.isEmpty((String)this.expectedResultText.getText())) {
            message = Messages.SubmitTicketDialog_ERR_EmptyExpectedResult;
        }
        this.setErrorMessage(message);
        if (message == null) {
            this.setMessage(Messages.SubmitTicketDialog_DefaultMessage);
        }
        if ((button = this.getButton(0)) != null) {
            button.setEnabled(message == null);
        }
        return message == null;
    }

    private void browse() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        String file = dialog.open();
        if (!StringUtil.isEmpty((String)file)) {
            final IPath path = Path.fromOSString((String)file);
            if (this.screenshots.contains(path)) {
                return;
            }
            this.screenshots.add(path);
            final Button checkbox = new Button(this.screenshotsComposite, 32);
            this.screenshotCheckboxes.add(checkbox);
            checkbox.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
            checkbox.setText(path.lastSegment());
            checkbox.setSelection(true);
            checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (checkbox.getSelection()) {
                        SubmitTicketDialog.this.screenshots.add(path);
                    } else {
                        SubmitTicketDialog.this.screenshots.remove(path);
                    }
                }
            });
            ((Composite)this.getContents()).layout(true, true);
            Shell shell = this.getShell();
            Point currentSize = shell.getSize();
            int neededHeight = shell.computeSize((int)-1, (int)-1).y;
            if (neededHeight > currentSize.y) {
                shell.setSize(currentSize.x, neededHeight);
            }
        }
    }

    private void layoutShell() {
        Point size = this.getInitialSize();
        Rectangle bounds = this.getConstrainedShellBounds(new Rectangle(0, 0, size.x, size.y));
        this.getShell().setSize(bounds.width, bounds.height);
    }

    private void setUILocked(boolean locked) {
        if (this.getContents() == null || this.getContents().isDisposed()) {
            return;
        }
        this.typeCombo.getCombo().setEnabled(!locked);
        this.severityCombo.getCombo().setEnabled(!locked);
        this.summaryText.setEnabled(!locked);
        this.reproduceText.setEnabled(!locked);
        this.actualResultText.setEnabled(!locked);
        this.expectedResultText.setEnabled(!locked);
        this.studioLogCheckbox.setEnabled(!locked);
        this.diagnosticLogCheckbox.setEnabled(!locked);
        this.screenshotText.setEnabled(!locked);
        this.browseButton.setEnabled(!locked);
        for (Button checkbox : this.screenshotCheckboxes) {
            checkbox.setEnabled(!locked);
        }
    }
}

